# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


"""
This is a tool for finding modules in timelinelib that has no unit tests.
"""


import os


source_root = os.path.abspath(os.path.join('..', 'source', 'timelinelib'))
test_root = os.path.abspath(os.path.join('..', 'test', 'unit'))

print("List of modules where no unit tests are found:")
for root, dirs, files in os.walk(source_root):
    for file in [f for f in files if f.endswith('.py')]:
        if file == 'dotfile.py':
            a = 1
        path = root[len(source_root) + 1:]
        test_path = os.path.join(test_root, path, file)
        if not os.path.exists(test_path):
            print(f"   {os.path.join(path, file)}")
