# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import unittest
from timelinelib.utils import unique_based_on_eq
from timelinelib.test.utils import an_event_with


class describe_unique_based_on_eq(unittest.TestCase):

    def test_with_different_events(self):
        event1 = an_event_with(human_start_time="3 Mar 2010",
                               human_end_time="6 Mar 2010",
                               text="Event 1")
        event2 = an_event_with(human_start_time="3 Mar 2010",
                               human_end_time="6 Mar 2010",
                               text="Event 2")

        events = [event1, event2, event1, event2]
        self.assertEqual(2, len(unique_based_on_eq(events)))


    def test_with_equal_events(self):
        event1 = an_event_with(human_start_time="3 Mar 2010",
                               human_end_time="6 Mar 2010",
                               text="Event")
        event2 = an_event_with(human_start_time="3 Mar 2010",
                               human_end_time="6 Mar 2010",
                               text="Event")

        events = [event1, event2, event1, event2]
        self.assertEqual(1, len(unique_based_on_eq(events)))
