# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import unittest
import os

from timelinelib.config.paths import ICONS_DIR, EVENT_ICONS_DIR, LOCALE_DIR, HELP_RESOURCES_DIR


class describe_paths(unittest.TestCase):

    def test_icons_dir_exists(self):
        self.assertIsNotNone(ICONS_DIR)
        self.assertTrue(ICONS_DIR.endswith('icons'))

    def test_event_icons_dir_exists(self):
        self.assertIsNotNone(EVENT_ICONS_DIR)
        self.assertTrue(EVENT_ICONS_DIR.endswith('icons' + os.sep + 'event_icons'))

    def test_locale_dir_exists(self):
        self.assertIsNotNone(LOCALE_DIR)
        self.assertTrue(LOCALE_DIR.endswith('translations'))

    def test_help_resources_dir_exists(self):
        self.assertIsNotNone(HELP_RESOURCES_DIR)
        self.assertTrue(HELP_RESOURCES_DIR.endswith('help_resources'))
