# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


"""Unittests of the class :class:`~timelinelib.config.menuiteminfo.MenuItemInfo`."""


import unittest
from timelinelib.config.menuiteminfo import MenuItemInfo
from unittest.mock import sentinel


class describe_menu_item_info(unittest.TestCase):

    def test_has_wxid_property(self):
        menu_item_info = MenuItemInfo(wxid=789)
        self.assertEqual(789, menu_item_info.wxid)

    def test_has_menu_item_property(self):
        menu_item_info = MenuItemInfo(menu_item=sentinel.MENU_ITEM)
        self.assertEqual(sentinel.MENU_ITEM, menu_item_info.menu_item)

    def test_menu_item_can_be_set(self):
        menu_item_info = MenuItemInfo()
        self.assertIsNone(menu_item_info.menu_item)
        menu_item_info.menu_item = sentinel.MENU_ITEM
        self.assertEqual(sentinel.MENU_ITEM, menu_item_info.menu_item)

    def test_has_config_key_property(self):
        key = "a-config-key"
        menu_item_info = MenuItemInfo(config_key=key)
        self.assertEqual(key, menu_item_info.config_key)

    def test_has_config_display_name_property(self):
        name = "a-display_name"
        menu_item_info = MenuItemInfo(config_display_name=name)
        self.assertEqual(name, menu_item_info.config_display_name)

    def test_config_display_name_can_be_set(self):
        menu_item_info = MenuItemInfo()
        self.assertEqual("", menu_item_info.config_display_name)
        name = "a-display_name"
        menu_item_info.config_display_name = name
        self.assertEqual(name, menu_item_info.config_display_name)

    def test_has_shortcut_key_property(self):
        key = 'C'
        menu_item_info = MenuItemInfo(shortcut_key=key)
        self.assertEqual(key, menu_item_info.shortcut_key)

    def test_shortcut_key_can_be_set(self):
        menu_item_info = MenuItemInfo()
        self.assertEqual("", menu_item_info.shortcut_key)
        key = 'C'
        menu_item_info.shortcut_key = key
        self.assertEqual(key, menu_item_info.shortcut_key)

    def test_has_shortcut_modifiers_property(self):
        modifier = 'Ctrl+Alt'
        menu_item_info = MenuItemInfo(shortcut_modifier=modifier)
        self.assertEqual(modifier, menu_item_info.shortcut_modifiers)

    def test_shortcut_modifiers_can_be_set(self):
        menu_item_info = MenuItemInfo()
        self.assertEqual("", menu_item_info.shortcut_modifiers)
        modifier = 'Ctrl+Alt'
        menu_item_info.shortcut_modifiers = modifier
        self.assertEqual(modifier, menu_item_info.shortcut_modifiers)

    def test_has_shortcut_property(self):
        menu_item_info = MenuItemInfo(shortcut_key='C', shortcut_modifier='Ctrl')
        self.assertEqual('Ctrl+C', menu_item_info.shortcut)

    def test_has_event_handler_property(self):
        handler = lambda x: x
        menu_item_info = MenuItemInfo(event_handler=handler)
        self.assertEqual(handler, menu_item_info.event_handler)

    def test_event_handler_can_be_set(self):
        menu_item_info = MenuItemInfo()
        self.assertIsNone(menu_item_info.event_handler)
        handler = lambda x: x
        menu_item_info.event_handler = handler
        self.assertEqual(handler, menu_item_info.event_handler)
