# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.test.cases.unit import UnitTestCase
from timelinelib.canvas.drawing.rect import Rect


class describe_rect(UnitTestCase):

    def test_intersects_can_take_both_rect_and_tuple(self):
        box = Rect(0, 0, 100, 100)
        inner_box_tuple = (10, 10, 10, 10)
        self.assertTrue(box.Intersects(Rect(*inner_box_tuple)))
        self.assertTrue(box.Intersects(inner_box_tuple))

    def test_clone_and_inflate(self):
        self.assertEqual(
            Rect(0, 0, 10, 10).CloneInflate(1, 2),
            Rect(-1, -2, 12, 14)
        )

    def test_clone_and_deflate(self):
        self.assertEqual(
            Rect(0, 0, 10, 10).CloneDeflate(1, 2),
            Rect(1, 2, 8, 6)
        )
