# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import unittest
from unittest.mock import Mock

from timelinelib.canvas.drawing.drawers.ballondrawer import break_word
from timelinelib.canvas.drawing.drawers.ballondrawer import break_line
from timelinelib.canvas.drawing.drawers.ballondrawer import break_sentence
from timelinelib.canvas.drawing.drawers.ballondrawer import get_max_word_length


class Dc:

    def GetTextExtent(self, s):
        return len(s) * 17, 0


class describe_function_break_word(unittest.TestCase):

    def test_a_long_word_broken(self):
        result = break_word("thisisaverylongword", 7)
        expected = ["thisisa-", "verylon-", "gword"]
        self.assertEqual(expected, result)

    def test_a_short_word_not_broken(self):
        result = break_word("short", 7)
        expected = ["short"]
        self.assertEqual(expected, result)

    def test_a_empty_word_not_broken(self):
        result = break_word("", 7)
        expected = [""]
        self.assertEqual(expected, result)


class describe_function_break_line(unittest.TestCase):

    def test_sentence_without_long_words(self):
        result = break_line("this is a test sentence", 12)
        expected = ["this", "is", "a", "test", "sentence"]
        self.assertEqual(expected, result)

    def test_sentence_with_one_word(self):
        result = break_line("sentence", 12)
        expected = ["sentence"]
        self.assertEqual(expected, result)

    def test_sentence_without_word(self):
        result = break_line("", 12)
        expected = [""]
        self.assertEqual(expected, result)

    def test_sentence_with_long_words(self):
        result = break_line("this is a test sentence withalongword", 12)
        expected = ["this", "is", "a", "test", "sentence", "withalongwor-", "d"]
        self.assertEqual(expected, result)


class describe_function_break_sentence(unittest.TestCase):

    def test(self):
        expected =  ['This is a', 'sentencewit-', 'halongword', 'that is', 'too long', 'to fit in', 'one row!!']
        lines = break_sentence(Dc(), "This is a sentencewithalongword that is too long to fit in one row!!", 200)
        self.assertEqual(expected, list(lines))


class describe_function_get_max_word_length(unittest.TestCase):

    def test(self):
        result = get_max_word_length(Dc(), 200)
        self.assertEqual(11, result)

