# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.test.cases.unit import UnitTestCase
import timelinelib.calendar.pharaonic.monthnames as monthnames


class DescribePharaonicMonthNames(UnitTestCase):

    def test_abbreviated_names_for_months(self):
        for month_inx, name in enumerate(monthnames.ABBREVIATED_ENGLISH_MONTH_NAMES):
            self.assertEqual(_(name), monthnames.abbreviated_name_of_month(month_inx + 1))

    def test_month_from_abbreviated_name(self):
        for inx, name in enumerate(monthnames.ABBREVIATED_ENGLISH_MONTH_NAMES):
            self.assertEqual(inx + 1, monthnames.month_of_abbreviated_name(_(name)))

    def test_abbreviated_name_for_month_1_should_be_I_Akhet_translated(self):
        self.assertEqual(_("I Akhet"), monthnames.abbreviated_name_of_month(1))

    def test_abbreviated_name_for_month_12_should_be_IV_Shemu_translated(self):
        self.assertEqual(_("IV Shemu"), monthnames.abbreviated_name_of_month(12))

    def test_abbreviated_name_for_month_13_should_be_Intercalary_Month_translated(self):
        self.assertEqual(_("IM"), monthnames.abbreviated_name_of_month(13))

    def test_month_of_unknown_abbreviated_name_generates_value_error(self):
        try:
            month = monthnames.month_of_abbreviated_name("Foo Bar")
            self.fail("Expected ValueError")
        except ValueError as ex:
            self.assertEqual('Could not find month name "Foo Bar".', str(ex))
