# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.gregorian.timetype import GregorianTimeType
from timelinelib.calendar.dec.time import DecDelta
from timelinelib.calendar.dec.time import DecTime
from timelinelib.calendar.dec.timetype.timetype import move_period
from timelinelib.calendar.dec.timetype.timetype import DecTimeType
from timelinelib.canvas.data import TimePeriod
from timelinelib.test.cases.unit import UnitTestCase


class describe_dec_timetype(UnitTestCase):

    def test_format_delta_1(self):
        self.assertEqual("1", DecTimeType().format_delta(DecDelta(1)))
        self.assertEqual("1.0", DecTimeType().format_delta(DecDelta(1.0)))

    def test_format_delta_2(self):
        self.assertEqual("2", DecTimeType().format_delta(DecDelta(2)))
        self.assertEqual("2.9", DecTimeType().format_delta(DecDelta(2.9)))

    def test_equality(self):
        self.assertEqual(DecTimeType(), DecTimeType())
        self.assertNotEqual(DecTimeType(), GregorianTimeType())


class decribe_dec_time_duplicate_functions(UnitTestCase):

    def test_move_period_adds_given_number_of_delta(self):
        self.assertEqual(
            TimePeriod(DecTime(7), DecTime(8)),
            move_period(TimePeriod(DecTime(1), DecTime(2)), 6)
        )
        self.assertEqual(
            TimePeriod(DecTime(7.1), DecTime(8.3)),
            move_period(TimePeriod(DecTime(1.1), DecTime(2.3)), 6)
        )
