# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.dec.time import DecDelta
from timelinelib.calendar.dec.time import DecTime
from timelinelib.test.cases.unit import UnitTestCase


class desribe_dec_time(UnitTestCase):

    def test_repr(self):
        self.assertEqual(repr(DecTime(5)), "DecTime<5>")
        self.assertEqual(repr(DecTime(5.1)), "DecTime<5.1>")

    def test_str(self):
        self.assertEqual(str(DecTime(5)), "DecTime<5>")
        self.assertEqual(str(DecTime(5.2)), "DecTime<5.2>")


class desribe_dec_delta(UnitTestCase):

    def test_repr(self):
        self.assertEqual(repr(DecDelta(5)), "DecDelta<5>")
        self.assertEqual(repr(DecDelta(5.3)), "DecDelta<5.3>")

    def test_str(self):
        self.assertEqual(str(DecDelta(5)), "DecDelta<5>")
        self.assertEqual(str(DecDelta(5.4)), "DecDelta<5.4>")
