# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.coptic.time import CopticDelta
from timelinelib.calendar.coptic.timetype.timetype import CopticTimeType
from timelinelib.test.cases.unit import UnitTestCase
from timelinelib.calendar.pharaonic.timetype.timetype import PharaonicTimeType


class describe_coptic_time_type(UnitTestCase):

    def test_equality(self):
        self.assertTrue(self.time_type == CopticTimeType())
        self.assertFalse(self.time_type == PharaonicTimeType())

    def test_inequality(self):
        self.assertFalse(self.time_type != CopticTimeType())
        self.assertTrue(self.time_type != PharaonicTimeType())

    def test_format_delta(self):
        self.assertEqual(
            self.time_type.format_delta(CopticDelta.from_seconds(
                60*60 + 60 + 40
            )),
            "1 ⟪hour⟫ 1 ⟪minute⟫ 40 ⟪seconds⟫"
        )
        self.assertEqual(
            self.time_type.format_delta(CopticDelta.from_days(366)),
            "1 ⟪year⟫ 1 ⟪day⟫"
        )

    def test_whole_number_of_years(self):
        from timelinelib.test.utils import gregorian_period
        self.assertTrue(self.time_type.whole_number_of_years(gregorian_period("11 Sep 2013", "11 Sep 2014")))
        self.assertTrue(self.time_type.whole_number_of_years(gregorian_period("9 Sep 1776", "9 Sep 1777")))
        self.assertFalse(self.time_type.whole_number_of_years(gregorian_period("8 Dec 1776", "8 Dec 1777")))
        self.assertFalse(self.time_type.whole_number_of_years(gregorian_period("6 Sep 2013", "11 Sep 2014")))

    def test_whole_number_of_months(self):
        from timelinelib.test.utils import gregorian_period
        self.assertTrue(self.time_type.whole_number_of_months(gregorian_period("9 Jan 2013", "9 Jan 2014")))
        self.assertTrue(self.time_type.whole_number_of_months(gregorian_period("6 Jul 1776", "6 Jul 1777")))
        self.assertFalse(self.time_type.whole_number_of_months(gregorian_period("2 Jan 2013", "2 Mar 2014")))
        self.assertFalse(self.time_type.whole_number_of_months(gregorian_period("1 Jan 2013 12:00", "1 Mar 2014")))

    def setUp(self):
        UnitTestCase.setUp(self)
        self.time_type = CopticTimeType()
