# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from unittest.mock import sentinel
from timelinelib.test.cases.unit import UnitTestCase
from timelinelib.calendar.bosparanian.dateformatter import BosparanianDateFormatter


class DescribeBosparanianDateFormatter(UnitTestCase):

    def test_is_bc_year(self):
        self.assertFalse(self.df._is_bc(sentinel.AnyYear))

    def test_format_year(self):
        self.assertEqual('2020', self.df._format_year(2020))
        self.assertEqual('-2020', self.df._format_year(-2020))

    def test_accept_negative_dates(self):
        self.assertTrue(self.df.accept_negative_dates())

    def test_abbreviated_name_of_month(self):
        self.assertEqual(_('PRA'), self.df.abbreviated_name_of_month(1))
        self.assertEqual(_('RON'), self.df.abbreviated_name_of_month(2))
        self.assertEqual(_('EFF'), self.df.abbreviated_name_of_month(3))
        self.assertEqual(_('TRA'), self.df.abbreviated_name_of_month(4))
        self.assertEqual(_('BOR'), self.df.abbreviated_name_of_month(5))
        self.assertEqual(_('HES'), self.df.abbreviated_name_of_month(6))
        self.assertEqual(_('FIR'), self.df.abbreviated_name_of_month(7))
        self.assertEqual(_('TSA'), self.df.abbreviated_name_of_month(8))
        self.assertEqual(_('PHE'), self.df.abbreviated_name_of_month(9))
        self.assertEqual(_('PER'), self.df.abbreviated_name_of_month(10))
        self.assertEqual(_('ING'), self.df.abbreviated_name_of_month(11))
        self.assertEqual(_('RAH'), self.df.abbreviated_name_of_month(12))
        self.assertEqual(_('NL'), self.df.abbreviated_name_of_month(13))

    def test_month_of_abbreviated_name(self):
        self.assertEqual(1, self.df.month_of_abbreviated_name(_('PRA')))
        self.assertEqual(2, self.df.month_of_abbreviated_name(_('RON')))
        self.assertEqual(3, self.df.month_of_abbreviated_name(_('EFF')))
        self.assertEqual(4, self.df.month_of_abbreviated_name(_('TRA')))
        self.assertEqual(5, self.df.month_of_abbreviated_name(_('BOR')))
        self.assertEqual(6, self.df.month_of_abbreviated_name(_('HES')))
        self.assertEqual(7, self.df.month_of_abbreviated_name(_('FIR')))
        self.assertEqual(8, self.df.month_of_abbreviated_name(_('TSA')))
        self.assertEqual(9, self.df.month_of_abbreviated_name(_('PHE')))
        self.assertEqual(10, self.df.month_of_abbreviated_name(_('PER')))
        self.assertEqual(11, self.df.month_of_abbreviated_name(_('ING')))
        self.assertEqual(12, self.df.month_of_abbreviated_name(_('RAH')))
        self.assertEqual(13, self.df.month_of_abbreviated_name(_('NL')))

    def test_nbr_of_days_in_month(self):
        for month in range(1, 13):
            self.assertEqual(30, self.df.days_in_month(2020, month))
        self.assertEqual(5, self.df.days_in_month(2020, 13))

    def setUp(self):
        self.df = BosparanianDateFormatter()