# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.

import wx


class MenuBase(wx.Menu):
    """A base class with code common to all menus (FileMenu, EditMenu ...)."""

    def __init__(self, main_frame, requiring_timeline, requiring_visible_timeline_view=[],
                 requiring_writeable_timeline=[]):
        wx.Menu.__init__(self)
        self._main_frame = main_frame
        self._requiring_timeline = requiring_timeline
        self._requiring_visible_timeline_view = requiring_visible_timeline_view
        self._requiring_writeable_timeline = requiring_writeable_timeline

    def get_menu_item_info(self, wxid):
        return [info for info in self._menu_items_info if info.wxid == wxid][0]

    def _bind_event_handlers(self):
        if self._menu_items_info:
            for menu_item_info in self._menu_items_info:
                self._main_frame.Bind(wx.EVT_MENU, menu_item_info.event_handler, id=menu_item_info.wxid)
        else:
            for wxid in self._event_handlers:
                self._main_frame.Bind(wx.EVT_MENU, self._event_handlers[wxid], id=wxid)

    def _register_shortcuts(self):
        if self._menu_items_info:
            menu_items_info = sorted(self._menu_items_info, key=lambda x: x.sort_order)
            for menu_item_info in menu_items_info:
                menu_item_info.menu_item = self.FindItemById(menu_item_info.wxid)
                self._main_frame.shortcut_controller.add_menu_item_info(menu_item_info)

    def _register_menus_requiring_timeline(self):
        for wxid in self._requiring_timeline:
            self._main_frame.menu_controller.add_menu_requiring_timeline(self.FindItemById(wxid))
        for wxid in self._requiring_visible_timeline_view:
            self._main_frame.menu_controller.add_menu_requiring_visible_timeline_view(self.FindItemById(wxid))
        for wxid in self._requiring_writeable_timeline:
            self._main_frame.menu_controller.add_menu_requiring_writable_timeline(self.FindItemById(wxid))
