# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import timelinelib.wxgui.frames.mainframe.menus as mid
from timelinelib.wxgui.frames.mainframe.menus.menubase import MenuBase
from timelinelib.wxgui.dialogs.feedback.view import show_feedback_dialog
from timelinelib.wxgui.dialogs.systeminfo.view import show_system_info_dialog
from timelinelib.meta.about import display_about_dialog
from timelinelib.wxgui.frames.helpbrowserframe.helpbrowserframe import HelpBrowserFrame
from timelinelib.config.menuiteminfo import MenuItemInfo
from timelinelib.config.shortcut import LABEL_HELP


REQUIRING_TIMELINE = list()
MENU_LABELS = {
    mid.ID_HELP: _("&Contents"),
    mid.ID_TUTORIAL: _("Getting started &tutorial"),
    mid.ID_NUMTUTORIAL: _("Getting started numeric &tutorial"),
    mid.ID_FEEDBACK: _("Give &Feedback") + "...",
    mid.ID_CONTACT: _("Co&ntact"),
    mid.ID_SYSTEM_INFO: _("System information"),
    mid.ID_ABOUT: _("About"),
}


class HelpMenu(MenuBase):
    """The Help menu (a wx.Menu)."""
    def __init__(self, main_frame):
        MenuBase.__init__(self, main_frame, REQUIRING_TIMELINE)
        help_browser = HelpBrowserFrame(main_frame)
        self._menu_items_info = self._create_menu_item_info(help_browser, main_frame)
        self._create_menu()
        self._bind_event_handlers()
        self._register_shortcuts()
        self._register_menus_requiring_timeline()

    def _create_menu_item_info(self, help_browser, main_frame):
        return [
            MenuItemInfo(wxid=mid.ID_HELP,
                         event_handler=help_browser.show_contents_page,
                         config_key="shortcut_help_content",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_HELP],
                         shortcut_key="F1",
                         sort_order=1),
            MenuItemInfo(wxid=mid.ID_TUTORIAL,
                         event_handler=lambda evt: main_frame.controller.open_or_create_a_timeline(":tutorial:"),
                         config_key="shortcut_tutorial",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_TUTORIAL],
                         sort_order=2),
            MenuItemInfo(wxid=mid.ID_NUMTUTORIAL,
                         event_handler=lambda evt: main_frame.controller.open_or_create_a_timeline(":numtutorial:"),
                         config_key="shortcut_numeric_tutorial",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_NUMTUTORIAL],
                         sort_order=3),
            MenuItemInfo(wxid=mid.ID_FEEDBACK,
                         event_handler=lambda evt: show_feedback_dialog(parent=None, info="", subject=_("Feedback"), body=""),
                         config_key="shortcut_feedback",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_FEEDBACK],
                         sort_order=4),
            MenuItemInfo(wxid=mid.ID_CONTACT,
                         event_handler=help_browser.show_contact_page,
                         config_key="shortcut_contact",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_CONTACT],
                         sort_order=5),
            MenuItemInfo(wxid=mid.ID_SYSTEM_INFO,
                         event_handler=show_system_info_dialog,
                         config_key="shortcut_system_info",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_SYSTEM_INFO],
                         sort_order=6),
            MenuItemInfo(wxid=mid.ID_ABOUT,
                         event_handler=display_about_dialog,
                         config_key="shortcut_about",
                         config_display_name=LABEL_HELP % MENU_LABELS[mid.ID_ABOUT],
                         sort_order=7),
        ]

    def _create_menu(self):
        self._append_menu_item(mid.ID_HELP)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_TUTORIAL)
        self._append_menu_item(mid.ID_NUMTUTORIAL)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_FEEDBACK)
        self._append_menu_item(mid.ID_CONTACT)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_SYSTEM_INFO)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_ABOUT)

    def _append_menu_item(self, wxid):
        self.Append(wxid, MENU_LABELS[wxid])
