# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.

import timelinelib.wxgui.frames.mainframe.menus as mid
from timelinelib.wxgui.frames.mainframe.menus.menubase import MenuBase
from timelinelib.wxgui.dialogs.preferences.view import open_preferences_dialog
from timelinelib.wxgui.dialogs.shortcutseditor.view import open_shortcuts_editor_dialog
from timelinelib.wxgui.dialogs.categoryfinder.view import open_category_finder_dialog
from timelinelib.wxgui.dialogs.milestonefinder.view import open_milestone_finder_dialog
from timelinelib.config.menuiteminfo import MenuItemInfo
from timelinelib.config.shortcut import CTRL_MODIFIER, LABEL_EDIT, SHIFT_CTRL_MODIFIER


REQUIRING_TIMELINE = (mid.ID_FIND, mid.ID_FIND_CATEGORIES, mid.ID_FIND_MILESTONES, mid.ID_SELECT_ALL)
MENU_LABELS = {
    mid.ID_FIND: _("Find") + "...",
    mid.ID_FIND_CATEGORIES: _("Find Categories") + "...",
    mid.ID_FIND_MILESTONES: _("Find Milestones") + "...",
    mid.ID_SELECT_ALL: _("Select All Events"),
    mid.ID_PREFERENCES: _("Preferences") + "...",
    mid.ID_EDIT_SHORTCUTS: _("Shortcuts") + "...",
}


class EditMenu(MenuBase):
    """The Edit menu (a wx.Menu). """

    def __init__(self, main_frame):
        MenuBase.__init__(self, main_frame, REQUIRING_TIMELINE)
        self._menu_items_info = self._create_menu_items_info(main_frame)
        self._create_menu()
        self._bind_event_handlers()
        self._register_shortcuts()
        self._register_menus_requiring_timeline()

    def _create_menu_items_info(self, main_frame):
        return [
            MenuItemInfo(wxid=mid.ID_FIND,
                         event_handler=lambda evt: main_frame.main_panel.DisplaySearchbar(True),
                         config_key="shortcut_find",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_FIND],
                         shortcut_key="F",
                         shortcut_modifier=CTRL_MODIFIER,
                         sort_order=1),
            MenuItemInfo(wxid=mid.ID_FIND_CATEGORIES,
                         event_handler=lambda evt: open_category_finder_dialog(main_frame),
                         config_key="shortcut_find_categories",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_FIND_CATEGORIES],
                         sort_order=2),
            MenuItemInfo(wxid=mid.ID_FIND_MILESTONES,
                         event_handler=lambda evt: open_milestone_finder_dialog(main_frame, main_frame.timeline),
                         config_key="shortcut_find_milestones",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_FIND_MILESTONES],
                         shortcut_key="M",
                         shortcut_modifier=SHIFT_CTRL_MODIFIER,
                         sort_order=3),
            MenuItemInfo(wxid=mid.ID_SELECT_ALL,
                         event_handler=lambda evt: self._main_frame.canvas.SelectAllEvents(),
                         config_key="shortcut_selectall",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_SELECT_ALL],
                         sort_order=4),
            MenuItemInfo(wxid=mid.ID_PREFERENCES,
                         event_handler=lambda evt: open_preferences_dialog(main_frame, main_frame.config),
                         config_key="shortcut_preferences",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_PREFERENCES],
                         sort_order=5),
            MenuItemInfo(wxid=mid.ID_EDIT_SHORTCUTS,
                         event_handler=lambda evt: open_shortcuts_editor_dialog(main_frame, main_frame.shortcut_controller),
                         config_key="shortcut_shortcuts",
                         config_display_name=LABEL_EDIT % MENU_LABELS[mid.ID_EDIT_SHORTCUTS],
                         sort_order=6),
        ]

    def _create_menu(self):
        self._append_menu_item(mid.ID_FIND)
        self._append_menu_item(mid.ID_FIND_CATEGORIES)
        self._append_menu_item(mid.ID_FIND_MILESTONES)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_SELECT_ALL)
        self.AppendSeparator()
        self._append_menu_item(mid.ID_PREFERENCES)
        self._append_menu_item(mid.ID_EDIT_SHORTCUTS)

    def _append_menu_item(self, wxid):
        self.Append(wxid, MENU_LABELS[wxid])
