# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import sys
from sys import version as python_version
import os
import platform
import wx

from timelinelib.config.paths import LOCALE_DIR
from timelinelib.wxgui.framework import Controller


class SystemInfoDialogController(Controller):

    def on_init(self, parent):
        self.view.SetSystemVersion(", ".join(platform.uname()))
        self.view.SetPythonVersion(python_version.replace("\n", ""))
        self.view.SetPythonEncoding(sys.getdefaultencoding())
        self.view.SetWxPythonVersion(wx.version())
        self.view.SetLocaleWxLanguage(self._get_locale_setting()[0])
        self.view.SetLocaleOsLanguage(self._get_locale_setting()[1])
        self.view.SetLocaleEncoding(self._get_locale_setting()[2])
        self.view.SetConfigFile(self._get_config_file(parent))
        self.view.SetDateFormat(self._get_date_format(parent))
        self.view.SetTranslationsDirectory(os.path.abspath(LOCALE_DIR))
        self.view.Fit()

    def _get_locale_setting(self):
        try:
            import locale
            lang, enc = locale.getdefaultlocale()
            loc = wx.Locale()
            language_info = wx.Locale().FindLanguageInfo(lang)
            if language_info is not None:
                language_name = language_info.CanonicalName
            else:
                language_name = 'Unrecognized'
            # language_name = loc.GetLanguageName(loc.GetSystemLanguage())
            encoding_name = loc.GetSystemEncodingName()
            return (language_name, lang, encoding_name)
        except TypeError:
            return " "

    def _get_config_file(self, parent):
        return parent.config.path if parent is not None else '?'

    def _get_date_format(self, parent):
        return parent.config.get_date_format() if parent is not None else '?'
