# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.wxgui.dialogs.setcontainer.controller import SetContainerDialogController
from timelinelib.wxgui.framework import Dialog


class SetContainerDialog(Dialog):

    """
    <BoxSizerVertical>
        <FlexGridSizer columns="2" growableColumns="1" proportion="1" border="ALL">
            <StaticText
                label="$(label)"
                align="ALIGN_CENTER_VERTICAL"
            />
            <ContainerChoice
                name="container_choice"
                db="$(db)"
                align="ALIGN_CENTER_VERTICAL"
            />
        </FlexGridSizer>
        <DialogButtonsOkCancelSizer
            border="LEFT|BOTTOM|RIGHT"
            event_EVT_BUTTON__ID_OK="on_ok_clicked"
        />
    </BoxSizerVertical>
    """

    def __init__(self, parent, db, selected_event_ids=[]):
        Dialog.__init__(self, SetContainerDialogController, parent, {
            "db": db,
            "label": _("Select a Container:"),
        })
        self.controller.on_init(parent, db, selected_event_ids)

    def PopulateContainers(self):
        self.container_choice.Fill(None)
        self.Fit()

    def GetSelectedContainer(self):
        return self.container_choice.GetSelectedContainer()

def open_set_container_dialog_for_selected_events(main_frame):
    selected_event_ids = main_frame.view_properties.get_selected_event_ids()
    dialog = SetContainerDialog(main_frame, main_frame.timeline, selected_event_ids)
    dialog.ShowModal()
    dialog.Destroy()
