# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


class StatusBarAdapter:
    """
    This class is used to update texts in the application status bar.
    It is "owned" by the
    :class:`~timelinelib.wxgui.frames.mainframe.mainframe.MainFrame` class.
    All messages to be displayed in the status bar should be passed in to one of the MainFrame functions:

        * :obj:`~timelinelib.wxgui.frames.mainframe.mainframe.MainFrame.DisplayStatus`
        * :obj:`~timelinelib.wxgui.frames.mainframe.mainframe.MainFrame.DisplayHiddenCount`
        * :obj:`~timelinelib.wxgui.frames.mainframe.mainframe.MainFrame.DisplayReadonly`

    The status bar is divided into three columns.

    The first column is used to display info about objects under the cursor.
    i.e. timeline and events.

    The second column is used to display the number of hidden events.

    The third column is used to signal if a timeline is set into read-onl mode.
    """

    HIDDEN_EVENT_COUNT_COLUMN = 1
    READ_ONLY_COLUMN = 2

    def __init__(self, wx_status_bar):
        self.wx_status_bar = wx_status_bar
        self.wx_status_bar.SetFieldsCount(3)
        self.wx_status_bar.SetStatusWidths([-1, 200, 150])

    def set_text(self, text):
        """Set text in the first column of the status bar."""
        self.wx_status_bar.SetStatusText(text)

    def set_hidden_event_count_text(self, text):
        """Set text in the second column of the status bar."""
        self.wx_status_bar.SetStatusText(text, self.HIDDEN_EVENT_COUNT_COLUMN)

    def set_read_only_text(self, text):
        """Set text in the third column of the status bar."""
        self.wx_status_bar.SetStatusText(text, self.READ_ONLY_COLUMN)
