# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


import wx

from timelinelib.wxgui.components.propertyeditors.iconeditor import FileToBitmapConverter


class FileDropTarget(wx.FileDropTarget):

    def __init__(self, canvas):
        wx.FileDropTarget.__init__(self)
        self._canvas = canvas

    def OnDropFiles(self, x, y, filenames):
        bitmap = FileToBitmapConverter().convert(filenames[0])
        event = self._canvas.controller.event_at(x, y)
        if event:
            event.set_icon(bitmap)
            event.save()
            return True
        else:
            return False

    def OnDragOver(self, x, y, defResult):
        if self._canvas.controller.event_at(x, y):
            return defResult
        else:
            return wx.DragNone
