# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.

"""
Contains the Monitoring class.

The monitoring functions comes into action if the flag DEBUG_ENABLED,
in the :doc:`timelinelib module <timelinelib>`, is set to True. 
This happens if the application argument --debug is used at start of Timeline. 
When DEBUG_ENABLED is True, timer and counting statistics are shown 
in the main panel.

:doc:`Tests are found here <unit_monitoring>`.
"""

from timelinelib.timer import Timer


class Monitoring:
    """
    * Kepp track of the number of times the timeline has been redrawn.
    * Measure the time it takes to redraw.
    """
    def __init__(self, timer=None):
        self._timeline_redraw_count = 0
        self._category_redraw_count = 0
        if timer is None:
            self._timer = Timer()
        else:
            self._timer = timer

    @property
    def timeline_redraw_count(self):
        """Return the number of times the timeline has been redrawn."""
        return self._timeline_redraw_count

    @property
    def category_redraw_count(self):
        """Return the number of times the category tree has been redrawn."""
        return self._category_redraw_count

    @property
    def timer_elapsed_ms(self):
        """Return the elapsed time in milliseconds."""
        return self._timer.elapsed_ms

    def count_timeline_redraw(self):
        """Increment counter."""
        self._timeline_redraw_count += 1

    def count_category_redraw(self):
        """Increment counter."""
        self._category_redraw_count += 1

    def timer_start(self):
        """Start time measurement."""
        self._timer.start()

    def timer_end(self):
        """Stop time measurement."""
        self._timer.end()
