# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.generic.timetype.strips.stripweekbase import StripWeekBase
from timelinelib.calendar.pharaonic.pharaonicdatetime import PharaonicDateTime
from timelinelib.calendar.pharaonic.time import PharaonicDelta
from timelinelib.calendar.pharaonic.time import PharaonicTime


class StripWeek(StripWeekBase):

    @classmethod
    def DateTimeClass(cls):
        return PharaonicDateTime

    @classmethod
    def DeltaClass(cls):
        return PharaonicDelta

    @classmethod
    def TimeClass(cls):
        return PharaonicTime

    def start(self, time):
        if self.appearance.get_week_start() == "monday":
            days_to_subtract = time.day_of_week
        else:
            # It is Sunday.
            days_to_subtract = (time.day_of_week + 1) % 10
        return self.TimeClass()(time.julian_day - days_to_subtract, 0)

    def increment(self, time):
        return time + self.delta_from_days(10)
