# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.pharaonic.time import PharaonicTime


def julian_day_to_pharaonic_ymd(julian_day):
    """
    This calendar calculation was originally published in Explanatory Supplement to the Astronomical Almanac,
    S.E. Urban and P.K. Seidelman, Eds. (2012). You can purchase the book at uscibooks.com/urban.htm.
    "15.11 Calendar Conversion Algorithms" from the following pdf is used in the below code.
    https://aa.usno.navy.mil/publications/docs/c15_usb_online.pdf

    !!! This conversion doesn't produce any leap days !!!
    """
    if julian_day < PharaonicTime.MIN_JULIAN_DAY:
        raise ValueError("pharaonic_day_to_gregorian_ymd only works for julian days >= %d, but was %d" %
                         (PharaonicTime.MIN_JULIAN_DAY, julian_day))

    y = 3968
    j = 47
    m = 0
    n = 13
    r = 1
    p = 365
    v = 0
    u = 1
    s = 30
    w = 0

    f = julian_day + j
    e = r * f + v
    g = (e % p) // r
    h = u * g + w
    day = ((h % s) // u) + 1
    month = (((h // s) + m) % n) + 1
    year = (e // p) - y + (n + m - month) // n
    return year, month, day
