# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.gregorian.gregoriandatetime import GregorianDateTime
from timelinelib.calendar.gregorian.time import GregorianDelta
from timelinelib.calendar.gregorian.time import GregorianTime
from timelinelib.calendar.timetype import TimeType
from timelinelib.canvas.data import TimePeriod
from timelinelib.calendar.gregorian.timetype.strips import StripMinute
from timelinelib.calendar.gregorian.timetype.strips import StripHour
from timelinelib.calendar.gregorian.timetype.strips import StripWeekday
from timelinelib.calendar.gregorian.timetype.strips import StripWeek
from timelinelib.calendar.gregorian.timetype.strips import StripDay
from timelinelib.calendar.gregorian.timetype.strips import StripMonth
from timelinelib.calendar.gregorian.timetype.strips import StripYear
from timelinelib.calendar.gregorian.timetype.strips import StripDecade
from timelinelib.calendar.gregorian.timetype.strips import StripCentury


class GregorianTimeType(TimeType):

    @property
    def name(self):
        return "gregoriantime"

    @property
    def TimeClass(self):
        return GregorianTime

    @property
    def DateTimeClass(self):
        return GregorianDateTime

    @property
    def DeltaClass(self):
        return GregorianDelta

    def get_navigation_functions(self):
        return [
            (_("Go to &Today") + "\tCtrl+T", self.go_to_today_fn),
            (_("Go to &Date...") + "\tCtrl+G", self.go_to_date_fn),
            ("SEP", None),
            (_("Backward") + "\tPgUp", self.backward_fn),
            (_("Forward") + "\tPgDn", self.forward_fn),
            (_("Forward One Wee&k") + "\tCtrl+K", self.forward_one_week_fn),
            (_("Back One &Week") + "\tCtrl+W", self.backward_one_week_fn),
            (_("Forward One Mont&h") + "\tCtrl+H", self.forward_one_month_fn),
            (_("Back One &Month") + "\tCtrl+M", self.backward_one_month_fn),
            (_("Forward One Yea&r") + "\tCtrl+R", self.forward_one_year_fn),
            (_("Back One &Year") + "\tCtrl+Y", self.backward_one_year_fn),
            ("SEP", None),
            (_("Fit Millennium"), self.fit_millennium_fn),
            (_("Fit Century"), self.create_strip_fitter(StripCentury)),
            (_("Fit Decade"), self.create_strip_fitter(StripDecade)),
            (_("Fit Year"), self.create_strip_fitter(StripYear)),
            (_("Fit Month"), self.create_strip_fitter(StripMonth)),
            (_("Fit Week"), self.fit_week_fn),
            (_("Fit Day"), self.create_strip_fitter(StripDay)),
        ]

    def choose_strip(self, metrics, appearance):
        """
        Return a tuple (major_strip, minor_strip) for current time period and
        window size.
        """
        day_period = TimePeriod(GregorianTime(0, 0), GregorianTime(1, 0))
        one_day_width = metrics.calc_exact_width(day_period)
        if one_day_width > 20000:
            return StripHour(), StripMinute()
        elif one_day_width > 600:
            return StripDay(), StripHour()
        elif one_day_width > 45:
            return StripWeek(appearance), StripWeekday()
        elif one_day_width > 25:
            return StripMonth(), StripDay()
        elif one_day_width > 1.5:
            return StripYear(), StripMonth()
        elif one_day_width > 0.12:
            return StripDecade(), StripYear()
        elif one_day_width > 0.012:
            return StripCentury(), StripDecade()
        else:
            return StripCentury(), StripCentury()

    def create_time_picker(self, parent, *args, **kwargs):
        from timelinelib.calendar.gregorian.timepicker.datetimepicker import GregorianDateTimePicker
        return GregorianDateTimePicker(parent, *args, **kwargs)
