# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.gregorian.gregoriandatetime import GregorianDateTime
from timelinelib.calendar.gregorian.monthnames import abbreviated_name_of_month
from timelinelib.calendar.gregorian.monthnames import month_of_abbreviated_name
from timelinelib.calendar.generic.dateformatter import GenericDateFormatter


class GregorianDateFormatter(GenericDateFormatter):

    def __init__(self):
        GenericDateFormatter.__init__(self, max_month=12)
        self.set_separators("-", "-")
        self.set_region_order(year=0, month=1, day=2)
        self.use_abbreviated_name_for_month(False)
        self._use_date_default_values = False
        self._default_year = '2000'
        self._default_month = '01'
        self._default_day = '01'

    def abbreviated_name_of_month(self, month):
        return abbreviated_name_of_month(month)

    def month_of_abbreviated_name(self, month_string):
        return month_of_abbreviated_name(month_string)

    def days_in_month(self, year, month):
        return GregorianDateTime.nbr_of_days_in_month(year, month)
