# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.canvas.drawing.interface import Strip


class StripWeekBase(Strip):

    def __init__(self, appearance):
        Strip.__init__(self)
        self.appearance = appearance

    def label(self, time, major=False):
        if major:
            first_weekday = self.start(time)
            next_first_weekday = self.increment(first_weekday)
            last_weekday = next_first_weekday - self.delta_from_days(1)
            range_string = self._time_range_string(first_weekday, last_weekday)
            if self.appearance.get_week_start() == "monday":
                return _("Week") + f" {self.datetime_from_time(time).week_number} ({range_string})"
            else:
                # It is sunday (don't know what to do about week numbers here)
                return range_string
        # This strip should never be used as minor
        else:
            return ""

    def _time_range_string(self, start, end):
        start = self.datetime_from_time(start)
        end = self.datetime_from_time(end)
        if start.year == end.year:
            if start.month == end.month:
                return "%s-%s %s %s" % (start.day, end.day,
                                        start.abbreviated_month_name,
                                        start.formatted_year)
            return "%s %s-%s %s %s" % (start.day,
                                       start.abbreviated_month_name,
                                       end.day,
                                       end.abbreviated_month_name,
                                       start.formatted_year)
        return "%s %s %s-%s %s %s" % (start.day,
                                      start.abbreviated_month_name,
                                      start.formatted_year,
                                      end.day,
                                      end.abbreviated_month_name,
                                      end.formatted_year)

    def start(self, time):
        if self.appearance.get_week_start() == "monday":
            days_to_subtract = time.day_of_week
        else:
            # It is Sunday.
            days_to_subtract = (time.day_of_week + 1) % 7
        return self.TimeClass()(time.julian_day - days_to_subtract, 0)

    def increment(self, time):
        return time + self.delta_from_days(7)
