# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.canvas.drawing.interface import Strip


class StripMinuteBase(Strip):

    def label(self, time, major=False):
        dt = self.datetime_from_time(time)
        if major:
            return "%s %s %s: %s:%s" % (dt.day, dt.abbreviated_month_name,
                                        dt.formatted_year, dt.hour, dt.minute)
        return str(dt.minute)

    def start(self, time):
        (hours, minutes, _) = time.get_time_of_day()
        return self.TimeClass()(time.julian_day, minutes * 60 + hours * 60 * 60)

    def increment(self, time):
        return time + self.delta_from_seconds(60)
