# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.timetype import TimeType
from timelinelib.calendar.coptic.copticdatetime import CopticDateTime
from timelinelib.calendar.coptic.time import CopticDelta
from timelinelib.calendar.coptic.time import CopticTime
from timelinelib.canvas.data import TimePeriod
from timelinelib.calendar.coptic.timetype.strips.stripcentury import StripCentury
from timelinelib.calendar.coptic.timetype.strips.stripweek import StripWeek
from timelinelib.calendar.coptic.timetype.strips.stripweekday import StripWeekday
from timelinelib.calendar.coptic.timetype.strips.stripminute import StripMinute
from timelinelib.calendar.coptic.timetype.strips.stripday import StripDay
from timelinelib.calendar.coptic.timetype.strips.stripdecade import StripDecade
from timelinelib.calendar.coptic.timetype.strips.striphour import StripHour
from timelinelib.calendar.coptic.timetype.strips.stripmonth import StripMonth
from timelinelib.calendar.coptic.timetype.strips.stripyear import StripYear


class CopticTimeType(TimeType):

    @property
    def name(self):
        return "coptic"

    @property
    def TimeClass(self):
        return CopticTime

    @property
    def DateTimeClass(self):
        return CopticDateTime

    @property
    def DeltaClass(self):
        return CopticDelta

    def get_navigation_functions(self):
        return [
            (_("Go to &Today") + "\tCtrl+T", self.go_to_today_fn),
            (_("Go to &Date...") + "\tCtrl+G", self.go_to_date_fn),
            ("SEP", None),
            (_("Backward") + "\tPgUp", self.backward_fn),
            (_("Forward") + "\tPgDn", self.forward_fn),
            (_("Forward One Wee&k") + "\tCtrl+K", self.forward_one_week_fn),
            (_("Back One &Week") + "\tCtrl+W", self.backward_one_week_fn),
            (_("Forward One Mont&h") + "\tCtrl+H", self.forward_one_month_fn),
            (_("Back One &Month") + "\tCtrl+M", self.backward_one_month_fn),
            (_("Forward One Yea&r") + "\tCtrl+R", self.forward_one_year_fn),
            (_("Back One &Year") + "\tCtrl+Y", self.backward_one_year_fn),
            ("SEP", None),
            (_("Fit Millennium"), self.fit_millennium_fn),
            (_("Fit Century"), self.create_strip_fitter(StripCentury)),
            (_("Fit Decade"), self.create_strip_fitter(StripDecade)),
            (_("Fit Year"), self.create_strip_fitter(StripYear)),
            (_("Fit Month"), self.create_strip_fitter(StripMonth)),
            (_("Fit Week"), self.fit_week_fn),
            (_("Fit Day"), self.create_strip_fitter(StripDay)),
        ]

    def choose_strip(self, metrics, appearance):
        """
        Return a tuple (major_strip, minor_strip) for current time period and
        window size.
        """
        day_period = TimePeriod(CopticTime(0, 0), CopticTime(1, 0))
        one_day_width = metrics.calc_exact_width(day_period)
        if one_day_width > 20000:
            return StripHour(), StripMinute()
        elif one_day_width > 600:
            return StripDay(), StripHour()
        elif one_day_width > 45:
            return StripWeek(appearance), StripWeekday()
        elif one_day_width > 25:
            return StripMonth(), StripDay()
        elif one_day_width > 1.5:
            return StripYear(), StripMonth()
        elif one_day_width > 0.12:
            return StripDecade(), StripYear()
        elif one_day_width > 0.012:
            return StripCentury(), StripDecade()
        else:
            return StripCentury(), StripCentury()

    def create_time_picker(self, parent, *args, **kwargs):
        from timelinelib.calendar.coptic.timepicker.datetimepicker import CopticDateTimePicker
        return CopticDateTimePicker(parent, *args, **kwargs)
