# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.coptic.time import CopticTime


def coptic_ymd_to_julian_day(year, month, day):
    """
    Coptic year 1 = Julian day 1825030
      julian_day = 1825030 + (year - 1) * 365 + (month - 1) * 30 + (day - 1)
      num_leap_days = num_leap_years(year)
      julian_day = 1825030 + (year - 1 - num_leap_days)*365 + num_leap_days*366 + (month - 1)*30 + (day - 1)
    """
    y = 4996
    j = 124
    m = 0
    n = 13
    r = 4
    p = 1461
    q = 0
    u = 1
    s = 30
    t = 0

    h = month - m
    g = year + y - (n - h) // n
    f = (h - 1 + n) % n
    e = (p * g + q) // r + day - 1 - j
    julian_day = e + (s * f + t) // u

    if julian_day < CopticTime.MIN_JULIAN_DAY:
        raise ValueError("coptic_ymd_to_julian_day only works for julian days >= %d, but was %d" %
                         (CopticTime.MIN_JULIAN_DAY, julian_day))
    return julian_day
