# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.bosparanian.bosparaniandatetime import BosparanianDateTime
from timelinelib.calendar.bosparanian.time import BosparanianDelta
from timelinelib.calendar.bosparanian.time import BosparanianTime
from timelinelib.calendar.timetype import TimeType
from timelinelib.canvas.data import TimePeriod
from timelinelib.calendar.bosparanian.timetype.strips.stripcentury import StripCentury
from timelinelib.calendar.bosparanian.timetype.strips.stripdecade import StripDecade
from timelinelib.calendar.bosparanian.timetype.strips.stripquarter import StripQuarter
from timelinelib.calendar.bosparanian.timetype.strips.stripyear import StripYear
from timelinelib.calendar.bosparanian.timetype.strips.stripmonth import StripMonth
from timelinelib.calendar.bosparanian.timetype.strips.stripweek import StripWeek
from timelinelib.calendar.bosparanian.timetype.strips.stripweekday import StripWeekday
from timelinelib.calendar.bosparanian.timetype.strips.stripday import StripDay
from timelinelib.calendar.bosparanian.timetype.strips.striphour import StripHour
from timelinelib.calendar.bosparanian.timetype.strips.stripminute import StripMinute
from timelinelib.wxgui.dialogs.changenowdate.view import open_change_now_date_dialog


class BosparanianTimeType(TimeType):

    def __init__(self):
        self.saved_now = None

    @property
    def name(self):
        return "bosparaniantime"

    @property
    def TimeClass(self):
        return BosparanianTime

    @property
    def DateTimeClass(self):
        return BosparanianDateTime

    @property
    def DeltaClass(self):
        return BosparanianDelta

    def get_navigation_functions(self):
        return [
            (_("Open &Now Date Editor") + "\tCtrl+T", self.open_now_date_editor),
            (_("Go to &Date...") + "\tCtrl+G", self.go_to_date_fn),
            ("SEP", None),
            (_("Backward") + "\tPgUp", self.backward_fn),
            (_("Forward") + "\tPgDn", self.forward_fn),
            (_("Forward One Wee&k") + "\tCtrl+K", self.forward_one_week_fn),
            (_("Back One &Week") + "\tCtrl+W", self.backward_one_week_fn),
            (_("Forward One Mont&h") + "\tCtrl+H", self.forward_one_month_fn),
            (_("Back One &Month") + "\tCtrl+M", self.backward_one_month_fn),
            (_("Forward One Yea&r") + "\tCtrl+R", self.forward_one_year_fn),
            (_("Back One &Year") + "\tCtrl+Y", self.backward_one_year_fn),
            ("SEP", None),
            (_("Fit Millennium"), self.fit_millennium_fn),
            (_("Fit Century"), self.create_strip_fitter(StripCentury)),
            (_("Fit Decade"), self.create_strip_fitter(StripDecade)),
            (_("Fit Year"), self.create_strip_fitter(StripYear)),
            (_("Fit Month"), self.create_strip_fitter(StripMonth)),
            (_("Fit Week"), self.fit_week_fn),
            (_("Fit Day"), self.create_strip_fitter(StripDay)),
            ("SEP", None),
        ]

    def choose_strip(self, metrics, appearance):
        """
        Return a tuple (major_strip, minor_strip) for current time period and
        window size.
        """
        day_period = TimePeriod(BosparanianTime(0, 0), BosparanianTime(1, 0))
        one_day_width = metrics.calc_exact_width(day_period)
        if one_day_width > 20000:
            return StripHour(), StripMinute()
        elif one_day_width > 600:
            return StripDay(), StripHour()
        elif one_day_width > 60:
            return StripMonth(), StripWeekday()
        elif one_day_width > 25:
            return StripMonth(), StripDay()
        elif one_day_width > 10:
            return StripMonth(), StripWeek()
        elif one_day_width > 1.75:
            return StripYear(), StripMonth()
        elif one_day_width > 0.5:
            return StripYear(), StripQuarter()
        elif one_day_width > 0.12:
            return StripDecade(), StripYear()
        elif one_day_width > 0.012:
            return StripCentury(), StripDecade()
        else:
            return StripCentury(), StripCentury()

    def supports_saved_now(self):
        return True

    def set_saved_now(self, time):
        self.saved_now = time

    def now(self):
        if self.saved_now is None:
            return BosparanianDateTime(1000, 1, 1, 12, 0, 0).to_time()
        return self.saved_now

    def is_special_day(self, time):
        return time.day_of_week == 3

    @staticmethod
    def create_time_picker(parent, *args, **kwargs):
        from timelinelib.calendar.bosparanian.timepicker.datetimepicker import BosparanianDateTimePicker
        return BosparanianDateTimePicker(parent, *args, **kwargs)

    @staticmethod
    def open_now_date_editor(main_frame, current_period, navigation_fn):

        def navigate_to(time):
            navigation_fn(lambda tp: tp.center(time))

        open_change_now_date_dialog(main_frame, navigate_to, _("Change Now Date"))
