# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


from timelinelib.calendar.generic.timetype.strips.stripcenturybase import StripCenturyBase
from timelinelib.calendar.bosparanian.bosparaniandatetime import BosparanianDateTime


class StripCentury(StripCenturyBase):

    @classmethod
    def DateTimeClass(cls):
        return BosparanianDateTime

    def label(self, time, major=False):
        if major:
            # TODO: This only works for English. Possible to localize?
            time = BosparanianDateTime.from_time(time)
            start_year = self._century_start_year(time.year)
            century = int((start_year + 100) // 100)
            if century <= 0:
                century -= 1
            return str(century) + " century BF"
        return ""

    def increment(self, time):
        time = BosparanianDateTime.from_time(time)
        return time.replace(year=time.year + 100).to_time()

    @classmethod
    def _century_start_year(cls, year):
        return int(year // 100) * 100
