# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


def bosparanian_day_to_ymd(bosparanian_day):
    """
    Converts a day number, counted from 1st PRA, 0 BF to standard bosparanian calendar date
    """
    bosp_day = bosparanian_day-(365*100*73)+3  # shift by 73 centuries and align week
    year = bosp_day // 365
    d = bosp_day - (year * 365)
    if d >= 360:
        month = 13
        day = d-359
        return year, month, day
    month = d // 30 + 1
    day = d % 30 + 1
    return year, month, day
