# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.


def ymd_to_bosparanian_day(year, month, day):
    """
    Converts a bosparanian date given as year, month, and day, to a day number counted from 1st PRA 0 BF
    """
    bosp_day = year * 365
    bosp_day += ((month - 1) // 13) * 365
    m = (month - 1) % 13
    bosp_day += m * 30
    bosp_day += day - 1
    bosparanian_day = bosp_day+(365*100*73)-3  # shift by 73 centuries and align week
    return bosparanian_day
