#!/usr/bin/env python3
#
# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018  Rickard Lindberg, Roger Lindberg
#
# This file is part of Timeline.
#
# Timeline is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Timeline is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeline.  If not, see <http://www.gnu.org/licenses/>.

"""
This is the module used to start Timeline.
"""


import gettext
import os
import platform
import sys

# Make sure that we can import timelinelib
sys.path.insert(0, os.path.dirname(os.path.realpath(__file__)))

from timelinelib.config.paths import LOCALE_DIR
from timelinelib.meta.about import APPLICATION_NAME

def main():
    """
    Before starting the application
        - the language translation system, gettext is installed.
        - `humblewx <https://github.com/thetimelineproj/humblewx>`_ is initialized.

    The application is started with a call to the function
    :doc:`start_wx_application <timelinelib_wxgui_setup>`.

    If the script is started with the argument ``-h`` it will print out the available
    arguments and options on the console.
    """

    if platform.system() == "Windows":
        # The appropriate environment variables are set on other systems
        import wx
        loc = wx.Locale()
        language = loc.GetLanguageCanonicalName(loc.GetSystemLanguage())
        os.environ['LANG'] = language
        if getattr(sys, 'frozen', False):
            os.chdir(os.path.dirname(sys.executable))

    gettext.install(APPLICATION_NAME.lower(), LOCALE_DIR)
    from timelinelib.wxgui.setup import setup_humblewx
    setup_humblewx()
    from timelinelib.wxgui.setup import start_wx_application
    start_wx_application()


if __name__ == '__main__':
    main()
