"""
This example displays the tutorial timeline in a wx.Frame window
using a user defined Canvas object that inherits from TimelineCanvas.

Hoovering the mouse over the timeline displays event information in the
status bar and also displays event balloon information if present.
"""


import wx

import timelineadaptor
from canvas import Canvas

from timelinelib.db import db_open


class MainFrame(wx.Frame):

    def __init__(self):
        wx.Frame.__init__(self, None, size=(800, 400))
        self.statusbar = self.CreateStatusBar(1)
        self._display_example_timeline()

    def _display_example_timeline(self):
        # The way to populate the canvas is to use a  database object from timelinelib
        # and call its display_in_canvas method.
        # The following code opens the tutorial timeline
        path_to_timeline_file = ":tutorial:"
        db = db_open(path_to_timeline_file)
        db.display_in_canvas(Canvas(self))


if __name__ == "__main__":
    app = wx.App()
    frame = MainFrame()
    frame.Show()
    app.MainLoop()
