import timelineadaptor

import wx

from timelinelib.canvas import TimelineCanvas
from timelinelib.canvas.data import TimePeriod


class CanvasZoom(TimelineCanvas):

    """
    Hold the Shift key down and drag with the mose to select the area to zoom in to.

    Without holding the Shift key down, a Right drag will zzom in and a left drag
    with the mouse will zoo out.
    """

    DRAG_ZOOM = 1

    def __init__(self, parent):
        TimelineCanvas.__init__(self, parent)
        self.Bind(wx.EVT_LEFT_DOWN, self._on_left_down)
        self.Bind(wx.EVT_MOTION, self._on_motion)
        self.Bind(wx.EVT_LEFT_UP, self._on_left_up)
        self.InitZoomSelect()
        self._function = None
        self._start_time = None

    def _on_left_down(self, evt):
        if evt.ShiftDown():
            self.StartZoomSelect(evt)
            self._function = self.DRAG_ZOOM
        else:
            self._start_time = self.GetTimeAt(evt.GetX())

    def _on_motion(self, evt):
        if  self._function == self.DRAG_ZOOM:
            self.DragZoom(evt)

    def _on_left_up(self, evt):
        if  self._function == self.DRAG_ZOOM:
            self.StopDragZoom()
        else:
            if self._start_time < self.GetTimeAt(evt.GetX()):
                self.ZoomIn()
            else:
                self.ZoomOut()
