"""
This example displays the tutorial timeline in a wx.Frame window
using a TimelineCanvas object.
"""

import wx

from timelinelib.canvas import TimelineCanvas


class MainFrame(wx.Frame):

    def __init__(self):
        wx.Frame.__init__(self, None, size=(800, 400))
        canvas = TimelineCanvas(self)
        self._display_example_timeline(canvas)

    def _display_example_timeline(self, canvas):
        # The way to populate the canvas is to use a  database object from timelinelib
        # and call its display_in_canvas method.
        # The following code opens the tutorial timeline
        from timelinelib.db import db_open
        path_to_timeline_file = ":tutorial:"
        db = db_open(path_to_timeline_file)
        db.display_in_canvas(canvas)


if __name__ == "__main__":
    app = wx.App()
    frame = MainFrame()
    frame.Show()
    app.MainLoop()
