"""
This example displays the tutorial timeline in a wx.Frame window
using a TimelineCanvas object.

By clicking with the cursor on a date in the timeline, the timeline will be scrolled
to a position where the selected date is in the center of the timeline.
"""


import wx

import timelineadaptor
from timelinelib.db import db_open

from canvas import Canvas


class MainFrame(wx.Frame):

    def __init__(self):
        wx.Frame.__init__(self, None, size=(800, 400))
        self._display_example_timeline()

    def _display_example_timeline(self):
        path_to_timeline_file = ":tutorial:"
        db_open(path_to_timeline_file).display_in_canvas(Canvas(self))


if __name__ == "__main__":
    app = wx.App()
    frame = MainFrame()
    frame.Show()
    app.MainLoop()
